<%@ page language="java" contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<%@ taglib uri="/WEB-INF/displaytag-12.tld" prefix="display" %>
<%@ taglib uri="http://beehive.apache.org/netui/tags-html-1.0" prefix="netui" %>

<c:set var="pageHelp" value="${pageFlow.completedSummaryHelpURI}" />
<c:set var="printerFriendlyPageAction" value="viewPrinterFriendlyResolvedStatusSummary" />
<c:set var="showUpdatingMsg" value="true" />

<%@ include file="pageHeader.jspf" %>
<%@ include file="wellnessReminderResolvedSummaryDescription.jspf" %>


<p>
	<display:table id="${pageFlow.tableUID}" 
	        uid="${pageFlow.tableUID}" 
		    name="${pageFlow.wellnessReminders}"
	        pagesize="10" 
	        sort="list"  
	        defaultsort="${pageFlow.defaultSortProperty}" 
	        defaultorder="${pageFlow.defaultSortOrder.name}"
	        requestURI="handleResolvedPagingAndSorting.do">
	    <display:setProperty name="custom.sort.class" 
            value="${pageFlow.sortClassName}" />
    	<display:setProperty name="basic.msg.empty_list"
	    	value="There are currently no Wellness Reminders available" />            
		<display:column property="wellnessStatus" sortable="true"  
		    title="Status"/>            
		<display:column property="dueDate" sortable="true"  
		    title="Due Date"/>
		<display:column property="subject" sortable="true" title="Wellness Reminder" 
		    href="viewDetails.do?fromPage=resolved" paramId="id" paramProperty="id"/>
		<display:column property="dateLastDone" sortable="true"  
		    title="Last Completed"/>    
		<display:column property="location" sortable="true" title="Location"/>
	</display:table>
</p>

 	<div class="mhv-button-container-align-right">
		<netui:anchor action="viewNonCompletedStatusSummary" styleClass="mhv-input-button">
			Go to Wellness Reminders
		</netui:anchor>
	</div>	
 	<div class="mhv-button-container-align-left">
		<netui:anchor action="viewPreferences" styleClass="mhv-input-button">
		  <netui:parameter name="fromPage" value="resolved"/>
			Go to Reminders Preferences
		</netui:anchor>
	</div>
<br/>
<%@ include file="goldStandardText.jspf"%>
<br/>

<%@ include file="../../common/pageFooter.jspf" %>